\version "2.24.1"
\include "italiano.ly"

\paper {
  #(set-paper-size "a4landscape")
  indent = 0\mm
  print-page-number = ##f
}

\header {
  title = "Pastorella"
  subtitle = "BWV 590"
  %subsubtitle = "F-dur."
  %copyright = "©Hautbois Edition"
  %tagline = "©Hautbois Edition"
  copyright = ""
  tagline = ""
  composer = "Johann Sebastian Bach"
  opus = "(1685-1750)"
}

globalOne = {
  \key fa \major
  \time 12/8
  \accidentalStyle Score.modern
}

IeVoiceOne = \relative fa' {
  \globalOne
  % bar 1 - 5
  \stemNeutral fa4._~\mordent fa8 la do, fa4._~ fa8 la8 sol |
  la8 do sib do fa do re\prall do re do4._~ |
  do8 fa la, sib fa' la, \stemUp sol fa' sol, la fa' sol, |
  fa8 fa' fa, mi fa sol do,4._~ do4._~ |
  do8 mi fa re mi fa do mi fa sib, mi fa |
  
  % bar 6 - 10
  s1. | s1. | s1. | s1. | s1. |
  
  % bar 11 - 16 (6 bars)
  sol'1.^~ |
  sol4. do4.^~ do2.^~ |
  do2.^~ do4 si8 do4 si8 |
  do4 mi,8 fa mi fa~ fa si fa fa mi fa |
  mi4. s4. s2. |
  s1. |
  
  % bar 17 - 21
  s1. |
  s1. |
  s1. |
  s1. |
  s2. la4\rest la8\rest sol4.^~ |
  
  % bar 22 - 26
  sol8 do, la' sib do, la' sol do, la' sib la sol |
  la8 do sib la do sib la4. lab4._~ |
  lab8 sib fa sol sib la sib la sol fa sol mib |
  re4 sib'8 mib,4 do'8 re,4 sib'8 la sib do |
  fa,8 sol la re, mib fa sib, do re sol, la sib_~ |
  
  % bar 27 - 31
  sib8 sol' la, sib la sol fa sol la sol4.\prallprall |
  la4 la'8 sold4 sol8 fad4 fa8_~ fa mi re |
  dod8 mi fa si, re dod re dod re sol,4.^~ |
  sol8 mi' sol, fa4.^~ fa8 re' fa, mi fa sol |
  fa8 dod' re sib dod re la dod re sol, dod re |
  
  % bar 32 - 37 (6 bars)
  fa,4. sol fa mi |
  re8 re' mi, fa re' sol, la re sol, la sol fad |
  sol8 sol' la, sib sol' do, re sol dod, re dod si |
  dod8 sol' re mi sol fa sol sib la sib la sol |
  la8 sol fa mi fa re sold fad mi la4 re,8 |
  do8 si do si la si la2. |
}

IeVoiceTwo = \relative fa' {
  \globalOne
  % bar 1 - 5
  s1. |
  s1. |
  s2. do8\rest do8\rest mi8 fa4 mi8 |
  do4 do8 \change Staff = "left" \stemUp sib4.^~ sib8 la sib sib la sib |
  la4. sib la sol |
  
  % bar 6 - 10
  la4. sib la sol |
  fa8 \change Staff = "right" \once \stemDown fa' \change Staff = "left" sol, la \change Staff = "right" \stemDown fa' sib, \stemNeutral do fa sib, do sib la |
  sib8 \change Staff = "right" sib' do, re sib' mi, fa sib mi, fa mi re |
  mi8 sib' fa sol sib la \stemUp sib sol' la, sib la sol |
  la8 sib do sib do la la^\prall sol la sol4. |
  
  % bar 11 - 16 (6 bars)
  \stemDown mi4. do'4._~ do8 mi sol, do4._~ |
  do8 mi re mi sol mi fa4._~ fa8 mi re |
  mi4 sol8 la4 sol8 fa4 fa8 sol4 fa8 |
  mi4 mi8 re4._~ re4 re8 re4 re8 |
  do4. fa mi re |
  do8 si do la si do sol si do fa, si do |
  
  % bar 17 - 21
  \stemNeutral mi,4 fa8 sol4 la8 sib4 la8 sib la sol |
  la4 si8 do4 re8 mib4 re8 mib re do |
  \stemUp re4 mi8 fa4 sol8 la4 sol8 la4 si8 |
  do4 mi,8 re mi do do4.^~ do8 si la |
  si8 re do si re do \stemDown si4. sib4._~ |
  
  % bar 22 - 26
  sib8 s8 s8 s4. s2. |
  s1. |
  s1. |
  s1. |
  s1. |
  
  % bar 27 - 31
  s1. | s1. | s1. | s1. | s1. |
  
  % bar 32 - 37 (6 bars)
  s1. |
  s1. |
  s1. |
  s1. |
  s2. s4. s4 la8 |
  la4. sold4. mi2. |  \bar "|."
}

IeVoiceThree = \relative fa {
  \globalOne
  % bar 1 - 5
  \stemNeutral re4\rest re8\rest fa4.^~ fa8 la do, fa4.^~ |
  fa8 la sol la do la sib4.^~ sib8 la sol |
  la4 do8 re4 do8 sib4 sib8 do4 sib8 |
  la4 la8 sol4 fa8 mi4._~ mi4. |
  fa2._~ fa4. sib,4.\rest |
  
  % bar 6 - 10
  \stemDown fa'8 mi fa re mi fa do mi fa sib, mi fa |
  la,4 sib8 do4 re8 mib4 re8 mib re do |
  re4 mi8 fa4 sol8 lab4 sol8 lab sol fa |
  sol4 la8 sib4 do8 \change Staff = "right" re4 do8 re4 mi8 |
  fa8 sol la sol la fa fa4._~ fa8 mi re |
  
  % bar 11 - 16 (6 bars)
  \change Staff = "left" \stemNeutral do4.^~ do8 mi sol, do4.^~ do8 mi re |
  \clef "treble" mi8 sol fa sol do sol la ^\prall ^\markup { \tiny \smaller \smaller { \musicglyph #"accidentals.natural" } } sol la sol4._~ |
  sol8 do mi, fa do' mi, re do' re, mi do' re, |
  do8 do' do, \clef "bass" \stemUp \once \mergeDifferentlyDottedOn si4.( si2.) |
  do8 s8 s8 \stemNeutral la si do sol si do fa, si do |
  mi,4. fa mi re |
  
  % bar 17 - 21
  do8 do' re, mi do' fa, sol do fa, sol fa mi |
  fa8 fa' sol, la fa' si, do fa si, do si la |
  \stemUp si \change Staff = "right" \stemDown fa' do re fa mi fa re' mi, fa mi re |
  mi fa sol fa sol mi mi re mi re4._~ |
  re8 \change Staff = "left" sol, mi' fa sol, mi' re sol, mi' fa sol, re' |
  
  % bar 22 - 26
  \once \stemUp mi8 \change Staff = "right" \stemDown sol fa mi sol fa mi4. \once \stemUp mib4.^~ |
  \once \stemUp mib4. mib8 \change Staff = "left" fa, \change Staff = "right" re' do \change Staff = "left" fa, \change Staff = "right" re' mib re do | 
  re4 sib8 mib4 do8 re4 sib8 lab'4._~ |
  lab8 sib fa sol sib la sib la sol fa sol mib |
  re8 mib do \change Staff = "left" \stemNeutral sib do la sol la fa mi fa re |
  
  % bar 27 - 31
  dod4. dod'4. \change Staff = "right" \stemDown re8 mi fa_~ fa mi re |
  dod8 si la si re dod re dod re sold,4. |
  la4 la'8 sold4 sol8 fad4 fa8_~ fa mi re |
  \change Staff = "left" \stemUp dod4._~ dod8 mi la, re4.^~ re4 dod!8 |
  re4. \stemNeutral sol, fa mi |
  
  % bar 32 - 37 (6 bars)
  re8 dod' re sib dod re la dod re sol, dod re |
  fa,4 sol8 la4 sib8 do4 sib8 do sib la |
  sib4 fad8 sol4 la8 sib4 la8 sib la sol |
  \change Staff = "right" \stemDown mi'4 si8 dod4 re8 mi sol fa sol fa mi |
  fa8 mi re \change Staff = "left" do si la si la sold mi'4 \stemUp fa8 |
  mi8 re mi re do re do2. |
}

IeVoiceFour = \relative fa {
  \globalOne
  % bar 1 - 5
  s1. | s1. | s1. | s1. | s1. |
  
  % bar 6 - 10
  s1. | s1. | s1. | s1. | s1. |
  
  % bar 11 - 16 (6 bars)
  s1. |
  s1. |
  s1. |
  s4. si8 do re sol,2.~ |
  sol8 si do s4. s4. s4. |
  s1. |
  
  % bar 17 - 21
  s1. | s1. | s1. | s1. | s1. |
  
  % bar 22 - 26
  s2. s4. \change Staff = "right" do4._~ |
  do8 fa, re' s4. s2. |
  s1. |
  s1. |
  s1. |
  
  % bar 27 - 31
  s1. |
  s1. |
  s1. |
  s2. \change Staff = "left" \stemDown re4 sold,8 la4._~ |
  la4. s4. s2. |
  
  % bar 32 - 37 (6 bars)
  s1. |
  s1. |
  s1. |
  s1. |
  s2. s4. s4 la8 |
  mi2._~ mi2. |
}

IePedal = \relative fa, {
  \globalOne
  % bar 1 - 5
  fa1._~ | fa1._~ | fa1._~ | fa1._~ | fa1._~ |
  
  % bar 6 - 10
  fa1._~ | fa1._~ | fa1._~ | fa1._~ | fa2. do'2._~ |
  
  % bar 11 - 16 (6 bars)
  do1._~ | do1._~  | do1._~  | do1._~ | do1._~ | do1._~ |
  
  % bar 17 - 21
  do1._~ | do1._~  | do1._~ | do2. sol2._~ | sol1. |
  
  % bar 22 - 26
  do1. | fa,1. | sib1._~ | sib1._~ | sib1. |
  
  % bar 27 - 31
  mi,2. re4. sib'4. | la1._~ | la1._~ | la1. | re,1._~ |
  
  % bar 32 - 37 (6 bars)
  re1._~ | re1._~ | re1._~ | re1._~ | re2._~ re4. do4 re8 | mi2. la2. |
}


\score {
  \header {
    piece = \markup { \bold \large { I. \italic { (Alla Siciliana) } } }
  }
  <<
    \new PianoStaff \with {
      \override StaffGrouper.
      staffgroup-staff-spacing.basic-distance = #0
    } <<
      \new Staff = "right" \with {
        midiInstrument = "church organ"
      } << \magnifyMusic 0.93 { \IeVoiceOne } 
           \\
           \magnifyMusic 0.93 { \IeVoiceTwo }
        >>
      \new Staff = "left" \with {
        midiInstrument = "church organ"
      } { \clef bass << \magnifyMusic 0.93 { \IeVoiceThree }
                        \\
                        \magnifyMusic 0.93 { \IeVoiceFour }
        >> }
    >>
    \new Staff = "pedal" \with {
    } { \clef bass \magnifyMusic 0.93 { \IePedal } }
  >>
  \layout {
    \context {
      \Score
      \override SpacingSpanner.common-shortest-duration =
        #(ly:make-moment 1/4)
    }
  }
}